//
//  BPCloudSignUpWorkers.h
//  BIViews
//
//  Created by Brent Gulanowski on 11-01-27.
//  Copyright 2011 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <BPViews/BPViewController.h>

@class MCTVToolbarView, BPCloudSignupWorkerInfo;

@interface BPCloudSignUpWorkers : BPViewController {

	MCTVToolbarView *tvToolbar;
	
	NSTextField *emailField;
	NSTableView *workersTable;
	
	NSArrayController *workersAC;
	NSMutableArray *workers;
	
	BOOL workerFirstNameMissing;
	BOOL workerLastNameMissing;
	BOOL workerEmailMissing;
	
	BOOL passwordValid;
	BOOL emailValid;
}

@property (nonatomic, assign) IBOutlet MCTVToolbarView *tvToolbar;
@property (nonatomic, assign) IBOutlet NSTextField *emailField;
@property (nonatomic, assign) IBOutlet NSTableView *workersTable;
@property (nonatomic, assign) IBOutlet NSArrayController *workersAC;

@property (nonatomic, retain) NSMutableArray *workers; // contains mutable dictionaries
@property (nonatomic, copy) BPCloudSignupWorkerInfo *firstWorker;

@property (readonly) BOOL requirementsMet;

@property (nonatomic) BOOL workerFirstNameMissing;
@property (nonatomic) BOOL workerLastNameMissing;
@property (nonatomic) BOOL workerEmailMissing;

@property (nonatomic) BOOL emailValid;

- (IBAction)add:(id)sender;
- (IBAction)remove:(id)sender;

@end

@interface NSMutableDictionary (BPCloudSignUp)

- (NSAttributedString *)userTableString;

@end

